#version 430

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

layout (location = 3) in uvec4 firstBoneIDs;
layout (location = 4) in vec4 firstBoneWeights;
layout (location = 5) in ivec3 instanceID;

layout (location = 0) out vec3 fragViewPos;
layout (location = 1) out smooth vec3 fragNormal;
layout (location = 2) out vec2 fragTexCoords;
layout (location = 3) out vec4 fragPosLightSpace;
layout (location = 4) flat out uvec3 fragInstanceID; 

// matrices for drawing shit
uniform mat4 projection;
uniform mat4 view;

uniform int modelID;
uniform int BoneCount; 

uniform mat4 lightSpaceMatrix;

layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;


mat4 getBone(uint boneID, uint instanceNumber){

	mat4 newMat;

		newMat[0] = vec4(imageLoad(inputTex, ivec2(20 + 4*boneID, instanceNumber)));
    newMat[1] = vec4(imageLoad(inputTex, ivec2(21 + 4*boneID, instanceNumber)));
    newMat[2] = vec4(imageLoad(inputTex, ivec2(22 + 4*boneID, instanceNumber)));
    newMat[3] = vec4(imageLoad(inputTex, ivec2(23 + 4*boneID, instanceNumber)));

	return newMat;

}


void main()

{
	mat4 model;
	int instanceNumber = gl_InstanceID;

	model[0] = vec4(imageLoad(inputTex, ivec2(0, instanceNumber)));
  model[1] = vec4(imageLoad(inputTex, ivec2(1, instanceNumber)));
  model[2] = vec4(imageLoad(inputTex, ivec2(2, instanceNumber)));
  model[3] = vec4(imageLoad(inputTex, ivec2(3, instanceNumber)));

	vec4 worldPos = vec4(position, 1.0);

	mat4 transformMatrix = mat4(1.0);
	
	if (BoneCount > 0){

	transformMatrix = firstBoneWeights.x * getBone(firstBoneIDs.x, instanceNumber);
	transformMatrix += firstBoneWeights.y * getBone(firstBoneIDs.y, instanceNumber);
	transformMatrix += firstBoneWeights.z * getBone(firstBoneIDs.z, instanceNumber);
	transformMatrix += firstBoneWeights.w * getBone(firstBoneIDs.w, instanceNumber);

	}
	
	vec3 fragPos = (model * transformMatrix * worldPos).xyz;

	fragViewPos = (view * vec4(fragPos, 1.0)).xyz;
	
	gl_Position = projection * view * model * transformMatrix * worldPos;

	fragTexCoords = texCoords;

  mat3 normalMatrix = transpose(inverse(mat3(view * model * transformMatrix)));
  fragNormal = normalMatrix * normal;

	fragPosLightSpace = lightSpaceMatrix * vec4(fragPos, 1.0);


	fragInstanceID.x = modelID; //this is modelID
	fragInstanceID.y = instanceID.r; // this is the instance ID
	fragInstanceID.z = uint(vec4(imageLoad(inputTex, ivec2(16, instanceNumber))).y); //playerID

}